;;  Programm:      ACM-SCHIEBENXYZ.LSP
;;  Befehlsaufruf: ACM-SCHIEBENXYZ
;;  Funktion:      Objekte verschieben um einen Wert in gewhlten Achsen.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: info@geracad.de
;;  Datum:         18.02.2024
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-schiebenxyz ( / rta34 rta35 rat01 rat02 rat03 rat04 rat05 rat06 rat07 rat08 rat09 rat10)
    (defun rat01 (rta01 / rta06 rta07 rta08)
        (if
          (and
            (= acm224achsenmovex "1")
            (= acm224achsenmovey "0")
            (= acm224achsenmovez "0")
          )
            (setq rta05 "X-Achse")
        )
        (if
          (and
            (= acm224achsenmovex "0")
            (= acm224achsenmovey "1")
            (= acm224achsenmovez "0")
          )
            (setq rta05 "Y-Achse")
        )
        (if
          (and
            (= acm224achsenmovex "0")
            (= acm224achsenmovey "0")
            (= acm224achsenmovez "1")
          )
            (setq rta05 "Z-Achse")
        )
        (if
          (and
            (= acm224achsenmovex "1")
            (= acm224achsenmovey "1")
            (= acm224achsenmovez "0")
          )
            (setq rta05 "X- und Y-Achse")
        )
        (if
          (and
            (= acm224achsenmovex "1")
            (= acm224achsenmovey "0")
            (= acm224achsenmovez "1")
          )
            (setq rta05 "X- und Z-Achse")
        )
        (if
          (and
            (= acm224achsenmovex "0")
            (= acm224achsenmovey "1")
            (= acm224achsenmovez "1")
          )
            (setq rta05 "Y- und Z-Achse")
        )
        (if
          (and
            (= acm224achsenmovex "1")
            (= acm224achsenmovey "1")
            (= acm224achsenmovez "1")
          )
            (setq rta05 "X-, Y- und Z-Achse")
        )
        (if (not rta05)
          (setq rta05 "")
        )
      (setq rta06 (getvar "DIMZIN"))
      (setvar "DIMZIN" 8)
      (setq rta07 (rtos acm224movingvalue))
      (setvar "DIMZIN" rta06)
        (if (= rta01 1)
          (progn
            (setq rta08
              (strcat
                "\n1 Objekt wurde um "
                rta07
                " Einheiten entlang der "
                rta05
                " verschoben. "
              )
            )
          )
          (progn
            (setq rta08
              (strcat
                "\n"
                (itoa rta01)
                " Objekte wurden um "
                rta07
                " Einheiten entlang der "
                rta05
                " verschoben. "
              )
            )
          )
        )
      (prompt rta08)
    )
    (defun rat02 (rta02 / )
        (if rta35 (setq *error* rta35))
        (if rta06
          (vl-catch-all-apply 'setvar (list "DIMZIN" rta06))
        )
        (if rta23
          (vl-catch-all-apply 'setvar (list "OSMODE" rta23))
        )
        (if rta22
          (vl-catch-all-apply 'setvar (list "CMDECHO" rta22))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun rat03 ( / rta09 rta10)
      (if
        (and
          (setq rta09 (rat05))
          (setq rta10 (rat04))
          (rat09)
        )
          (rat06 rta09 rta10)
      )
    )
    (defun rat04 ( / rta06 rta11)
      (setq rta06 (getvar "DIMZIN"))
      (setvar "DIMZIN" 8)
      (setq rta11 (getdist (strcat "\nVerschieben um <" (rtos acm224movingvalue) ">: ")))
      (setvar "DIMZIN" rta06)
        (if (not rta11)
          (setq rta11 acm224movingvalue)
          (setq acm224movingvalue rta11)
        )
      rta11
    )
    (defun rat05 ( / rta13 rta14 rta15)
      (prompt "\nZu verschiebende Objekte whlen ... ")
        (if (setq rta13 (ssget))
          (progn
            (setq rta14 (sslength rta13))
              (if (= rta14 1)
                (prompt "\n1 zu verschiebendes Objekt gewhlt. ")
                (prompt (strcat "\n" (itoa rta14) " zu verschiebende Objekte gewhlt. "))
              )
            (setq rta15 rta13)
          )
          (progn
            (prompt "Keine zu verschiebenden Objekte gewhlt. ")
            (setq rta15 nil)
          )
        )
      rta15
    )
    (defun rat06 (rta03 rta04 / rta14 rta16 rta17 rta18 rta19 rta20 rta21 rta22 rta23)
      (setq rta14 (sslength rta03))
      (setq rta16 -1)
      (setq rta17 (list 0.0 0.0 0.0))
        (if (= acm224achsenmovex "0")
          (setq rta18 0.0)
          (setq rta18 rta04)
        )
        (if (= acm224achsenmovey "0")
          (setq rta19 0.0)
          (setq rta19 rta04)
        )
        (if (= acm224achsenmovez "0")
          (setq rta20 0.0)
          (setq rta20 rta04)
        )
      (setq rta21 (list rta18 rta19 rta20))
      (setq rta22 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq rta23 (getvar "OSMODE"))
      (setvar "OSMODE" 0)
      (vl-cmdf "._move" rta03 "" rta17 rta21)
      (rat01 rta14)
      (setvar "OSMODE" rta23)
      (setvar "CMDECHO" rta22)
    )
    (defun rat07 ( / rta26 rta24 rta25)
      (if
        (and
          (setq rta24 (vl-filename-mktemp "acm.dcl"))
          (setq rta25 (open rta24 "w"))
        )
          (progn
              (setq rta26
                (list
                  "achsenmove"
                  ":dialog{label=\042Einstellung\042;"
                  ":spacer{height=0.2;}"
                  ":text{label=\042Verschieben entlang der\042;}"
                  ":toggle{key=\042tg_x\042;label=\042&X-Achse\042;}"
                  ":toggle{key=\042tg_y\042;label=\042&Y-Achse\042;}"
                  ":toggle{key=\042tg_z\042;label=\042&Z-Achse\042;}"
                  ":spacer{height=0.2;}"
                  ":row{"
                  ":spacer{width=0;}"
                  ":column{width=0;"
                  ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                  ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                  ":spacer{width=0;}}}"
              )
            )
              (while rta26
                (write-line (car rta26) rta25)
                (setq rta26 (cdr rta26))
              )
            (setq rta25 (close rta25))
            rta24
          )
          nil
      )
    )
    (defun rat08 ( / rta27 rta15)
      (setq rta27 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= rta27 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq rta15 T)
            (setq rta15 nil)
        )
        (if (not rta15)
          (alert "\042acm-schiebenxyz\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      rta15
    )
    (defun rat09 ( / rta28 rta29)
        (if (setq rta28 (rat07))
          (progn
            (setq rta29 (load_dialog rta28))
              (if (not (new_dialog "achsenmove" rta29))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list rta28))
            (set_tile "tg_x" acm224achsenmovex)
            (set_tile "tg_y" acm224achsenmovey)
            (set_tile "tg_z" acm224achsenmovez)
              (if
                (and
                  (= (atoi (get_tile "tg_x")) 0)
                  (= (atoi (get_tile "tg_y")) 0)
                  (= (atoi (get_tile "tg_z")) 0)
                )
                  (mode_tile "b_01" 1)
              )
              (action_tile "tg_x" "(if
                (and
                  (= (atoi $value) 0)
                  (= (atoi (get_tile \"tg_y\")) 0)
                  (= (atoi (get_tile \"tg_z\")) 0)
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0))"
              )
              (action_tile "tg_y" "(if
                (and
                  (= (atoi (get_tile \"tg_x\")) 0)
                  (= (atoi $value) 0)
                  (= (atoi (get_tile \"tg_z\")) 0)
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0))"
              )
              (action_tile "tg_z" "(if
                (and
                  (= (atoi (get_tile \"tg_x\")) 0)
                  (= (atoi (get_tile \"tg_y\")) 0)
                  (= (atoi $value) 0)
                )
                  (mode_tile \"b_01\" 1)
                  (mode_tile \"b_01\" 0))"
              )
              (action_tile "b_01" "(setq rta30
                  (list
                    (setq acm224achsenmovex (get_tile \"tg_x\"))
                    (setq acm224achsenmovey (get_tile \"tg_y\"))
                    (setq acm224achsenmovez (get_tile \"tg_z\"))
                  )
                )
                (done_dialog)"
              )
            (action_tile "b_02" "(setq rta30 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog rta29)
          )
        )
      rta30
    )
    (defun rat10 ( / )
      (if (not (vl-position acm224achsenmovex (list "0" "1")))
        (setq acm224achsenmovex "1")
      )
      (if (not (vl-position acm224achsenmovey (list "0" "1")))
        (setq acm224achsenmovey "0")
      )
      (if (not (vl-position acm224achsenmovez (list "0" "1")))
        (setq acm224achsenmovez "0")
      )
      (if (not (vl-position (type acm224movingvalue) (list 'INT 'REAL)))
        (setq acm224movingvalue 1.0)
      )
    )
  (if (rat08)
    (progn
      (vl-load-com)
      (setq rta34 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq rta35 *error*)
      (setq *error* rat02)
      (vla-EndUndoMark rta34)
      (vla-StartUndoMark rta34)
      (rat10)
      (rat03)
        (if rta35
          (setq *error* rta35)
          (setq *error* nil)
        )
      (vla-EndUndoMark rta34)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-SCHIEBENXYZ (Copyright  2024 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-SCHIEBENXYZ auf.")
